// GetAccounts.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "GetAccounts.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetAccounts dialog


CGetAccounts::CGetAccounts(CWnd* pParent /*=NULL*/)
	: CDialog(CGetAccounts::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetAccounts)
	//}}AFX_DATA_INIT
}

CGetAccounts ::CGetAccounts(IApplication *pApp):CDialog(CGetAccounts::IDD, NULL)
{
	pApplication = pApp;
	//pAccount.CreateInstance(__uuidof(WPAccount));
	
}
void CGetAccounts::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetAccounts)
	DDX_Control(pDX, IDC_GETACCOUNTS_WITHEXTREFID, m_GetAccts);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGetAccounts, CDialog)
	//{{AFX_MSG_MAP(CGetAccounts)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetAccounts message handlers
BOOL CGetAccounts::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadcolumnHeaders();
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CGetAccounts ::LoadcolumnHeaders()
{
	m_GetAccts.InsertColumn(0,_T("AccountID"),LVCFMT_LEFT,100);
	m_GetAccts.InsertColumn(1,_T("AccountName"),LVCFMT_LEFT,200);
}

void CGetAccounts::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			int iCol =0;
			int nListViewCounter = m_GetAccts.GetItemCount();
			CString sAcctName, sAcctID;
			sAcctID.Format(_T("%ld"), pAccount->AccountID);
			sAcctName = (LPCSTR) pAccount->AccountName;
			m_GetAccts.SetItemText(nListViewCounter, 0, sAcctID);
			m_GetAccts.SetItemText(nListViewCounter, 1, sAcctName);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}
